variable "server_port" {
  description = "Numer portu używany przez serwer dla żądań HTTP"
  type        = number
  default     = 8080
}

variable "number_example" {
  description = "Przykład zmiennej typu number w Terraform"
  type        = number
  default     = 42
}

variable "list_example" {
  description = "Przykład zmiennej typu list w Terraform"
  type        = list
  default     = ["a", "b", "c"]
}

variable "list_numeric_example" {
  description = "Przykład zmiennej w postaci listy liczb w Terraform"
  type        = list(number)
  default     = [1, 2, 3]
}

variable "map_example" {
  description = "Przykład mapowania w Terraform"
  type        = map(string)

  default = {
    key1 = "wartość1"
    key2 = "wartość2"
    key3 = "wartość3"
  }
}

variable "object_example" {
  description = "Przykład typu strukturalnego w Terraform"
  type        = object({
    name    = string
    age     = number
    tags    = list(string)
    enabled = bool
  })

  default = {
    name    = "value1"
    age     = 42
    tags    = ["a", "b", "c"]
    enabled = true
  }
}

variable "security_group_name" {
  description = "Nazwa grupy bezpieczeństwa"
  type        = string
  default     = "terraform-example-instance"
}
